<?php
/**
 * Plugin Name: Secure Stripe Download
 * Description: Secure ZIP delivery plugin after Stripe payment.
 * Version: 1.0
 * Author: ChatGPT
 */


<?php
// Exit if accessed directly
if (!defined('ABSPATH')) exit;

function ssd_admin_menu() {
    add_menu_page('Secure Download', 'Secure Download', 'manage_options', 'secure-download', 'ssd_admin_page');
}
add_action('admin_menu', 'ssd_admin_menu');

function ssd_admin_page() {
    if (!current_user_can('manage_options')) return;

    if (isset($_POST['submit']) && !empty($_FILES['zip_file']['tmp_name'])) {
        $upload_dir = wp_upload_dir();
        $secure_dir = $upload_dir['basedir'] . '/secure';

        if (!file_exists($secure_dir)) {
            mkdir($secure_dir, 0755, true);
            file_put_contents($secure_dir . '/.htaccess', "deny from all");
        }

        $filename = basename($_FILES['zip_file']['name']);
        $destination = $secure_dir . '/' . $filename;

        if (move_uploaded_file($_FILES['zip_file']['tmp_name'], $destination)) {
            update_option('ssd_uploaded_zip', $filename);
            echo "<div class='notice notice-success'><p>File uploaded successfully.</p></div>";
        } else {
            echo "<div class='notice notice-error'><p>Failed to upload file.</p></div>";
        }
    }

    $uploaded = get_option('ssd_uploaded_zip');
    ?>
    <div class="wrap">
        <h1>Upload Secure ZIP File</h1>
        <form method="post" enctype="multipart/form-data">
            <input type="file" name="zip_file" accept=".zip" required>
            <br><br>
            <input type="submit" name="submit" class="button button-primary" value="Upload ZIP">
        </form>
        <?php if ($uploaded): ?>
            <p>Current file: <strong><?php echo esc_html($uploaded); ?></strong></p>
        <?php endif; ?>
    </div>
    <?php
}



<?php
function ssd_start_session() {
    if (!session_id()) {
        session_start();
    }
}
add_action('init', 'ssd_start_session');

function ssd_check_success_param() {
    if (isset($_GET['success']) && $_GET['success'] === 'stripe') {
        $_SESSION['download_ok'] = true;
        wp_redirect(remove_query_arg('success'));
        exit;
    }
}
add_action('template_redirect', 'ssd_check_success_param');

function ssd_download_shortcode() {
    if (!isset($_SESSION['download_ok']) || !$_SESSION['download_ok']) {
        return "<p>Unauthorized access. Please complete your purchase.</p>";
    }

    $file = get_option('ssd_uploaded_zip');
    if (!$file) return "<p>No file available for download.</p>";

    $upload_dir = wp_upload_dir();
    $download_url = admin_url('admin-ajax.php') . "?action=ssd_force_download";

    ob_start(); ?>
    <p>Preparing your download...</p>
    <script>
        setTimeout(function() {
            window.location.href = "<?php echo esc_url($download_url); ?>";
        }, 3000);
    </script>
    <?php
    return ob_get_clean();
}
add_shortcode('secure_download', 'ssd_download_shortcode');

function ssd_force_download() {
    if (!isset($_SESSION['download_ok']) || !$_SESSION['download_ok']) {
        wp_die("Unauthorized download.");
    }

    $_SESSION['download_ok'] = false; // prevent reuse

    $file = get_option('ssd_uploaded_zip');
    if (!$file) wp_die("No file found.");

    $upload_dir = wp_upload_dir();
    $filepath = $upload_dir['basedir'] . '/secure/' . $file;

    if (!file_exists($filepath)) wp_die("File not found.");

    header('Content-Description: File Transfer');
    header('Content-Type: application/zip');
    header('Content-Disposition: attachment; filename="' . basename($filepath) . '"');
    header('Content-Length: ' . filesize($filepath));
    flush();
    readfile($filepath);
    exit;
}
add_action('wp_ajax_ssd_force_download', 'ssd_force_download');
add_action('wp_ajax_nopriv_ssd_force_download', 'ssd_force_download');

