<?php
if (!defined('ABSPATH')) exit;

function ssd_admin_menu() {
    add_menu_page('Secure Download', 'Secure Download', 'manage_options', 'secure-download', 'ssd_admin_page');
}
add_action('admin_menu', 'ssd_admin_menu');

function ssd_admin_page() {
    if (!current_user_can('manage_options')) return;

    if (isset($_POST['submit']) && !empty($_FILES['zip_file']['tmp_name'])) {
        $upload_dir = wp_upload_dir();
        $secure_dir = $upload_dir['basedir'] . '/secure';

        if (!file_exists($secure_dir)) {
            mkdir($secure_dir, 0755, true);
            file_put_contents($secure_dir . '/.htaccess', "deny from all");
        }

        $filename = basename($_FILES['zip_file']['name']);
        $destination = $secure_dir . '/' . $filename;

        if (move_uploaded_file($_FILES['zip_file']['tmp_name'], $destination)) {
            update_option('ssd_uploaded_zip', $filename);
            echo "<div class='notice notice-success'><p>File uploaded successfully.</p></div>";
        } else {
            echo "<div class='notice notice-error'><p>Failed to upload file.</p></div>";
        }
    }

    $uploaded = get_option('ssd_uploaded_zip');
    ?>
    <div class="wrap">
        <h1>Upload Secure ZIP File</h1>
        <form method="post" enctype="multipart/form-data">
            <input type="file" name="zip_file" accept=".zip" required>
            <br><br>
            <input type="submit" name="submit" class="button button-primary" value="Upload ZIP">
        </form>
        <?php if ($uploaded): ?>
            <p>Current file: <strong><?php echo esc_html($uploaded); ?></strong></p>
        <?php endif; ?>
    </div>
    <?php
}
