<?php
require 'stripe/init.php';
\Stripe\Stripe::setApiKey('sk_live_MLErt6vGShAsg5qrtwDVvvzq00TSQmVem4');

// Set full year date range (2025)
$startDate = strtotime('2025-04-04 00:00:00');
$endDate = time();

$refundsOnly = [];
$hasMore = true;
$startingAfter = null;

while ($hasMore) {
    $params = [
        'limit' => 100,
        'created' => [
            'gte' => $startDate,
            'lte' => $endDate,
        ],
        'expand' => ['data.refunds'],
    ];

    if ($startingAfter) {
        $params['starting_after'] = $startingAfter;
    }

    $charges = \Stripe\Charge::all($params);

    foreach ($charges->data as $charge) {
        $hasRefund = $charge->refunded || !empty($charge->refunds->data);
        if (!$hasRefund) continue;

        $refundAmount = 0;
        foreach ($charge->refunds->data as $refund) {
            $refundAmount += $refund->amount / 100;
        }

        $refundsOnly[] = [
            'id' => $charge->id,
            'description' => $charge->description ?? 'N/A',
            'date' => date('Y-m-d H:i:s', $charge->created),
            'client_name' => $charge->billing_details->name ?? 'N/A',
            'amount' => $charge->amount / 100,
            'refund' => $refundAmount,
            'currency' => strtoupper($charge->currency),
        ];
    }

    $hasMore = $charges->has_more;
    if ($hasMore) {
        $startingAfter = end($charges->data)->id;
    }
}

// Export CSV
if (isset($_GET['export']) && $_GET['export'] === '1') {
    header('Content-Type: text/csv');
    header('Content-Disposition: attachment; filename="stripe_refunds_2025.csv"');
    $out = fopen('php://output', 'w');
    fputcsv($out, ['Charge ID', 'Description', 'Date', 'Client Name', 'Currency', 'Amount', 'Refund Amount']);
    foreach ($refundsOnly as $r) {
        fputcsv($out, [$r['id'], $r['description'], $r['date'], $r['client_name'], $r['currency'], $r['amount'], $r['refund']]);
    }
    fclose($out);
    exit;
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>2025 Refunded Transactions</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<div class="container mt-5">
    <h2 class="mb-4">Refunded Stripe Transactions (2025)</h2>
    <form method="GET">
        <button type="submit" name="export" value="1" class="btn btn-success mb-3">Export CSV</button>
    </form>
    <div class="table-responsive">
        <table class="table table-bordered table-striped">
            <thead class="table-dark">
                <tr>
                    <th>Charge ID</th>
                    <th>Description</th>
                    <th>Date</th>
                    <th>Client Name</th>
                    <th>Currency</th>
                    <th>Amount</th>
                    <th>Refund Amount</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($refundsOnly as $row): ?>
                    <tr class="table-danger">
                        <td><?= htmlspecialchars($row['id']) ?></td>
                        <td><?= htmlspecialchars($row['description']) ?></td>
                        <td><?= $row['date'] ?></td>
                        <td><?= htmlspecialchars($row['client_name']) ?></td>
                        <td><?= $row['currency'] ?></td>
                        <td><?= number_format($row['amount'], 2) ?></td>
                        <td><?= number_format($row['refund'], 2) ?></td>
                    </tr>
                <?php endforeach; ?>
                <?php if (empty($refundsOnly)): ?>
                    <tr><td colspan="7" class="text-center">No refunds found for 2025.</td></tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>
</body>
</html>
