<?php
function theme_register_menus() {
    register_nav_menus(array(
        'primary' => __('Primary Menu'),
        'mobile'  => __('Mobile Menu'),
    ));
}
add_action('after_setup_theme', 'theme_register_menus');
class Custom_Walker_Nav_Menu extends Walker_Nav_Menu {
    function start_lvl(&$output, $depth = 0, $args = array()) {
        $output .= '<ul class="nav-submenu scroll-sm position-absolute tw-start-0 top-100 tw-w-max bg-white tw-rounded-md overflow-y-auto tw-p-2 tw-mt-4 tw-duration-200 tw-z-99">';
    }

    function start_el(&$output, $item, $depth = 0, $args = array(), $id = 0) {
        $has_children = in_array('menu-item-has-children', $item->classes);
        $class_names = implode(' ', $item->classes);
        $link_class = $depth === 0 ? 'nav-menu__link hover--translate-y-1 tw-pe-5 text-heading tw-py-9 fw-semibold w-100' : 'nav-submenu__link hover-bg-neutral-200 text-heading fw-semibold w-100 d-block tw-py-2 tw-px-305 tw-rounded';
        $li_class = $depth === 0 ? 'nav-menu__item' : 'nav-submenu__item';

        if ($has_children) {
            $li_class .= ' has-submenu position-relative';
        }

        $output .= '<li class="' . esc_attr($li_class) . '">';
        $output .= '<a href="' . esc_attr($item->url) . '" class="' . $link_class . '">' . esc_html($item->title) . '</a>';
    }

    function end_el(&$output, $item, $depth = 0, $args = array()) {
        $output .= "</li>";
    }

    function end_lvl(&$output, $depth = 0, $args = array()) {
        $output .= "</ul>";
    }
}
class Mobile_Walker_Nav_Menu extends Walker_Nav_Menu {
  function start_lvl(&$output, $depth = 0, $args = array()) {
    $output .= '<ul class="nav-submenu tw-ml-4 tw-mt-2">';
  }

  function start_el(&$output, $item, $depth = 0, $args = array(), $id = 0) {
    $li_class = $depth === 0 ? 'nav-menu__item tw-py-2' : 'nav-submenu__item';
    $link_class = $depth === 0
        ? 'nav-menu__link tw-block text-heading tw-py-2 fw-semibold'
        : 'nav-submenu__link tw-block text-heading tw-py-2 tw-px-4';

    $output .= '<li class="' . esc_attr($li_class) . '">';
    $output .= '<a href="' . esc_url($item->url) . '" class="' . esc_attr($link_class) . '">';
    $output .= esc_html($item->title) . '</a>';
  }

  function end_el(&$output, $item, $depth = 0, $args = array()) {
    $output .= '</li>';
  }

  function end_lvl(&$output, $depth = 0, $args = array()) {
    $output .= '</ul>';
  }
}


?>